public class Pipe implements Comparable<Pipe> {
	private double diameter;
	private int numberOfPipes;
	public static final double TOLERANCE= 10E-15;
	
	public Pipe(double diameter, int numberOfPipes) {
		this.diameter = diameter;
		this.numberOfPipes = numberOfPipes;
	}

	public double getDiameter() {
		return diameter;
	}

	public int getNumberOfPipes() {
		return numberOfPipes;
	}
	@Override								// Remove @Override if your compiler complains
	public int compareTo(Pipe other) {		// Defines order
		if (Math.abs(diameter - other.diameter) < TOLERANCE) return 0;
	    if (diameter < other.diameter) return -1;
	    return 1;
	}
	
	public String toString() {
		return("Diameter: " + diameter + " number: " + numberOfPipes);
	}
}